/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Keys;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class IntroState
extends GameState {
    private Font customFont;
    private Font customFont2;
    private Color color;
    private long startFadeIn;
    private long startWait = -1L;
    private long startFadeOut = -1L;
    private int alpha = 255;

    public IntroState(GameStateManager gsm) {
        this.gsm = gsm;
        try {
            this.customFont = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")).deriveFont(52.0f);
            this.customFont2 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")).deriveFont(22.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/ka1.ttf")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        this.startFadeIn = System.nanoTime();
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        long elapsedOut;
        long elapsedWait;
        this.handleInput();
        long elapsedIn = (System.nanoTime() - this.startFadeIn) / 1000000L;
        if (elapsedIn > 5L && this.startWait == -1L && this.startFadeOut == -1L) {
            this.startFadeIn = System.nanoTime();
            this.alpha -= 3;
            if (this.alpha < 0) {
                this.alpha = 0;
            }
            if (this.alpha == 0) {
                this.startWait = System.nanoTime();
                this.startFadeIn = -1L;
            }
        }
        if ((elapsedWait = (System.nanoTime() - this.startWait) / 1000000L) > 1000L && this.startFadeIn == -1L && this.startFadeOut == -1L) {
            this.startFadeOut = System.nanoTime();
            this.startWait = -1L;
        }
        if ((elapsedOut = (System.nanoTime() - this.startFadeOut) / 1000000L) > 5L && this.startFadeIn == -1L && this.startWait == -1L) {
            this.startFadeOut = System.nanoTime();
            this.alpha += 3;
            if (this.alpha > 255) {
                this.alpha = 255;
            }
            if (this.alpha == 255) {
                this.gsm.setState(0);
                AudioPlayer.loop("introMusic", 0.0);
            }
        }
        this.color = new Color(0, 0, 0, this.alpha);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setFont(this.customFont);
        g.setColor(Color.WHITE);
        this.gsm.drawCenteredString("Work4Games", 800, 375, g);
        g.setFont(this.customFont2);
        this.gsm.drawCenteredString("Presents...", 800, 475, g);
        g.setColor(this.color);
        g.fillRect(0, 0, 800, 400);
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ENTER)) {
            this.gsm.setState(0);
            AudioPlayer.loop("introMusic", 0.0);
        }
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            System.exit(0);
        }
    }
}

